unit MainUnit;

//  
//       
//      TStringGrid. 
//         
//         .
//       ,  
//   Object Inspector.

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, StdCtrls, Mask, ExtCtrls, Buttons;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    StringGrid1: TStringGrid;
    MaskEditDate: TMaskEdit;
    CheckBoxState: TCheckBox;
    ComboBoxCountry: TComboBox;
    ButtonDlg: TButton;
    OpenDialog1: TOpenDialog;
    EditStr: TEdit;
    LabelTitle: TLabel;
    procedure FormShow(Sender: TObject);
    procedure StringGrid1DrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure MaskEditDateChange(Sender: TObject);
    procedure CheckBoxStateClick(Sender: TObject);
    procedure ComboBoxCountryClick(Sender: TObject);
    procedure ButtonDlgEnter(Sender: TObject);
    procedure EditStrChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

procedure TMainForm.FormShow(Sender: TObject);
begin
 //    
 //  ( )  
 StringGrid1.Options  := StringGrid1.Options + [goColSizing] - [goEditing];
 //     
 StringGrid1.RowCount := 9;
 StringGrid1.Cells[0,1]:=' ';
 StringGrid1.Cells[0,2]:='';
 StringGrid1.Cells[0,3]:='';
 StringGrid1.Cells[0,4]:=' 1';
 StringGrid1.Cells[0,5]:=' 2';
 StringGrid1.Cells[0,6]:='';
 StringGrid1.Cells[0,7]:='  1';
 StringGrid1.Cells[0,8]:='  2';
 //     
 StringGrid1.ColCount := 7;
 StringGrid1.Cells[1,0]:=' ';
 StringGrid1.Cells[2,0]:='';
 StringGrid1.Cells[3,0]:='';
 StringGrid1.Cells[4,0]:='';
 StringGrid1.Cells[5,0]:='';
 StringGrid1.Cells[6,0]:=' ';
end;

procedure TMainForm.StringGrid1DrawCell(Sender: TObject; ACol,
  ARow: Integer; Rect: TRect; State: TGridDrawState);
begin
 //    
 MaskEditDate.Visible    := False;
 EditStr.Visible         := False;
 ComboBoxCountry.Visible := False;
 CheckBoxState.Visible   := False;
 ButtonDlg.Visible       := False;

 //    , 
 if (gdFocused in State)
 then begin
    case ACol of
    1 : begin  //   TMaskEdit
     //     
     MaskEditDate.Text:=StringGrid1.Cells[ACol, ARow];
     //      
     MaskEditDate.Left := Rect.Left + StringGrid1.Left+2;
     MaskEditDate.Top := Rect.Top + StringGrid1.top+2;
     //       
     MaskEditDate.Width := Rect.Right - Rect.Left;
     MaskEditDate.Height := Rect.Bottom - Rect.Top;
     //    
     MaskEditDate.Visible := True;
    end;
    2 : begin  //   TEdit
     //     
     EditStr.Text:=StringGrid1.Cells[ACol, ARow];
      //     
     EditStr.Left := Rect.Left + StringGrid1.Left+2;
     EditStr.Top := Rect.Top + StringGrid1.top+2;
     EditStr.Width := Rect.Right - Rect.Left;
     EditStr.Height := Rect.Bottom - Rect.Top;
     EditStr.Visible  := True;
    end;
    3: begin //   TComboBox
     //     
     ComboBoxCountry.Text:=StringGrid1.Cells[ACol, ARow];
     //     
     ComboBoxCountry.Left := Rect.Left + StringGrid1.Left+2;
     ComboBoxCountry.Top := Rect.Top + StringGrid1.top+2;
     ComboBoxCountry.Width := Rect.Right - Rect.Left;
     ComboBoxCountry.Height := Rect.Bottom - Rect.Top;
     ComboBoxCountry.Visible := True;
    end;
   4..5 : begin //   TCheckBox
     //     
     CheckBoxState.Caption:=StringGrid1.Cells[ACol, ARow];
     if CheckBoxState.Caption=''
     then CheckBoxState.Checked := True
     else CheckBoxState.Checked := False;
     //     
     CheckBoxState.Left := Rect.Left + StringGrid1.Left+2;
     CheckBoxState.Top := Rect.Top + StringGrid1.top+2;
     CheckBoxState.Width := Rect.Right - Rect.Left;
     CheckBoxState.Height := Rect.Bottom - Rect.Top;
     CheckBoxState.Visible := True;
    end;
    6: begin //   TButton
     //     
     ButtonDlg.Left := Rect.Left + StringGrid1.Left + 2
                    + (Rect.Right - Rect.Left)- ButtonDlg.Width;
     ButtonDlg.Top := Rect.Top + StringGrid1.top + 2;
     ButtonDlg.Height := Rect.Bottom - Rect.Top;
     ButtonDlg.Visible := True;
    end;
    end; // of case
 end;
end;

//     TMaskEdit
procedure TMainForm.MaskEditDateChange(Sender: TObject);
begin
 StringGrid1.Cells[StringGrid1.Col, StringGrid1.Row]:=MaskEditDate.Text;
end;

//     TCheckBox
procedure TMainForm.CheckBoxStateClick(Sender: TObject);
begin
 if CheckBoxState.Checked
 then CheckBoxState.Caption:=''
 else CheckBoxState.Caption:='';
 StringGrid1.Cells[StringGrid1.Col, StringGrid1.Row]:=CheckBoxState.Caption;
end;

//     TComboBox
procedure TMainForm.ComboBoxCountryClick(Sender: TObject);
begin
  StringGrid1.Cells[StringGrid1.Col, StringGrid1.Row]:=ComboBoxCountry.Text;
end;

//     TButton.
//      (   onDrawCell)
//   ,  onClick   
//    Aplication.   onClick,  
//     onEnter,  (  )
//       .

procedure TMainForm.ButtonDlgEnter(Sender: TObject);
var ShortFileName : string;
begin
  if OpenDialog1.Execute
  then begin
     ShortFileName := ExtractFileName(OpenDialog1.FileName);
     StringGrid1.Cells[StringGrid1.Col, StringGrid1.Row]:=ShortFileName;
  end;

end;

//     TEdit
procedure TMainForm.EditStrChange(Sender: TObject);
begin
  StringGrid1.Cells[StringGrid1.Col, StringGrid1.Row]:=EditStr.Text;
end;

end.
